 ; Ŀ
 ;   Full function text editing from within AutoCAD                        
 ;   Copyright 1994 by Rocket Software                                     
 ;   Let's see if we can't finesse Autodesk...                             
 ; 
 ; Ŀ
 ;   First want to get an ss and delete anything in it that isn't text.    
 ;   Then put the entities in it in order by height, get the text strings  
 ;   and write them to a file in that order (probably by making an         
 ;   ordered list of the enames).  Then edit the file and write the lines  
 ;   back to the entities in the correct order - first line from file =    
 ;   first entity in list.                                                 
 ; 
 (DEFUN C:PFP (/ num ss enam ssord nextxt lu ename ypos poslst llist zz yhigh
                                 nulist fn pa pb vang vdist pt2 entt cc enttx)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Ask whether to ssget and process or allow selection in order.         
 ; 
  (write-line "Select text to edit or <Return> for individual selection: ")
  (setq num 0)
  (setq ss (ssget))
 ; Ŀ
 ;   If there is an ss then the routine is to process the text, so delete  
 ;   anything in it that isn't text.                                       
 ; 
  (if ss
     (progn
          (while (setq enam (ssname ss num))
                 (if (/= (cdr (assoc 0 (entget enam))) "TEXT")
                     (ssdel enam ss)
                     (setq num (1+ num)))))
 ; Ŀ
 ;   There is no ss: the user wishes to make his own list.  Allow          
 ;   selection, don't add non-text entities to the list.                   
 ;   Maybe use an ss for this - they won't allow multiple copies of one    
 ;   ename in the list.                                                    
 ; 
     (progn
          (setq ssord (ssadd))
          (while (setq nextxt (car (entsel "\nSelect text: ")))
                 (if (= "TEXT" (cdr (assoc 0 (entget nextxt))))
                     (ssadd nextxt ssord)
                     (write-line "\nThat wasn't text")))))
 ; Ŀ
 ;   Should now have one of two selection sets: ss, which is not in        
 ;   order, or ssord which is in the order in which it is to be used.      
 ;   If there is no ss then leave ssord alone (assuming that it exists).   
 ;   If there is an ss then copy the enames from it to ssord in order of   
 ;   height.                                                               
 ; 
  (if ss 
      (progn
          (setq ssord (ssadd))                ; make empty ss Ssord
          (setq lu (getvar "luprec"))
          (setvar "luprec" 7)
 ; Ŀ
 ;   Make the list of (ypos ename) lists from ss.                          
 ; 
          (while (setq ename (ssname ss 0))  ; while the ss still has members
                 (setq ypos (caddr (assoc 10 (entget ename)))) ; get the Y pos
                 (setq poslst (list ypos ename))            ; list Y pos & enam
                 (setq llist (append llist (list poslst)))  ; add list to llist
                 (ssdel ename ss))                          ; del ent from ss
 ; Ŀ
 ;   Now extract the highest entity from the main list (Llist), add it     
 ;   to Ssord and remove the sublist from Llist, repeat until Llist is     
 ;   empty.                                                                
 ; 
          (while (> (length llist) 0)           ; while Llist has members
          (setq num 0)
          (setq zz (list max))                  ; initialise max function list
          (while (setq poslst (nth num llist))  ; get next sublist
                 (setq zz (append zz (list (car poslst)))) ; add ypos to f list
                 (setq num (1+ num)))           ; next nth in list
          (setq yhigh (eval zz))                ; evaluate it: hh = highest pos
 ; Ŀ
 ;   Now add the matching ename to Ssord and remove the sublist from       
 ;   Llist.                                                                
 ; 
          (setq num 0)                              ; start at beginning
 ; Ŀ
 ;   While Ypos (car poslst) /= the highest Y value (yhigh), append the    
 ;   current sublist (poslst) to nulist, go on to the next pos in Llist.   
 ; 
          (setq nulist ())                          ; empty nulist
          (while (/= yhigh (car (setq poslst (nth num llist))))
                 (setq nulist (append nulist (list poslst)))
                 (setq num (1+ num)))               ; try next
 ; Ŀ
 ;   Now have the position of the correct sublist.  Extract the ename      
 ;   and add it to Ssord.                                                  
 ; 
          (ssadd (cadr (nth num llist)) ssord)      ; add ename to ss
 ; Ŀ
 ;   Now want to add the rest of the sublists to nulist, which will        
 ;   become the new Llist.                                                 
 ; 
          (setq num (1+ num))                       ; bypass current position
          (while (setq poslst (nth num llist))
                 (setq nulist (append nulist (list poslst)))
                 (setq num (1+ num)))               ; get next sublist
 ; Ŀ
 ;   Nulist now becomes the new Llist, return to the start of the while    
 ;   loop until Nulist is empty.                                           
 ; 
          (setq llist nulist))            ; while Llist has members end
          (setvar "luprec" lu)))          ; reset luprec, if ss progend, ifend


 ; Ŀ
 ;   Should now have a selection set, Ssord, in either order of            
 ;   decreasing height or in the order the user wanted.                    
 ;   Now write the text strings out in order to a text file.               
 ; 
  (setq fn (Open "edtex" "w"))
  (setq num 0)
  (while (setq enam (ssname ssord num))
         (write-line (cdr (assoc 1 (entget enam))) fn)
         (setq num (1+ num)))
  (Close fn)
 ; Ŀ
 ;   Fire up a text editor and load edtex into it.                         
 ; 
  (command "XXX" "edtex")
 ; Ŀ
 ;   We are now back from the editing session and must put the text back   
 ;   into the entities in the correct order.                               
 ; 
 ; Ŀ
 ;   Might need new text entities if there are new lines of text in the    
 ;   file, so get the angle and distance between two text lines.           
 ;   If there was only one text entity use the default value 1.            
 ; 
  (setq pa (cdr (assoc 10 (entget (ssname ssord 0)))))
  (if (setq pb (ssname ssord 1))
      (progn
           (setq pb (cdr (assoc 10 (entget pb))))
           (setq vang (angle pa pb))
           (setq vdist (distance pa pb))
           (setq pt2 (polar (list 0 0) vang vdist)))
      (progn
           (setq vdist (cdr (assoc 40 (setq entt (entget (ssname ssord 0))))))
           (setq vdist (* 1.61905 vdist))
           (setq vang (- (cdr (assoc 50 entt)) (/ pi 2)))
           (setq pt2 (polar (list 0 0) vang vdist))))
 ; Ŀ
 ;   Now open the (presumably edited) text file and read it back into      
 ;   the text entities.  If there are not enough entities for the number   
 ;   of lines in the file, make some new ones.                             
 ; 
  (setq fn (Open "edtex" "r"))
  (while (setq cc (read-line fn))
         (if (> (sslength ssord) 0)
             (progn
                  (setq enttx (entget (setq ename (ssname ssord 0))))
                  (ssdel (ssname ssord 0) ssord))
              (progn
                  (command "copy" ename "" "0,0" pt2)
                  (setq enttx (entget (setq ename (entlast))))))
         (entmod (subst (cons 1 cc) (assoc 1 enttx) enttx)))
  (Close fn)
 ; Ŀ
 ;   If there are any lines of text in the ss which have not been given    
 ;   a new text string then they must no longer have a string, so delete   
 ;   them.                                                                 
 ; 
  (while (setq enttx (ssname ssord 0))
         (ssdel enttx ssord)
         (entdel enttx))
 (princ))